/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.plugin.jei;

import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.SafeClientAccess;
import slimeknights.mantle.recipe.crafting.ShapedRetexturedRecipe;

public class RetexturableRecipeExtension
implements ICraftingCategoryExtension {
    private final ShapedRetexturedRecipe recipe;
    private final List<class_1799> displayOutputs;
    private final int[] textureSlots;

    RetexturableRecipeExtension(ShapedRetexturedRecipe recipe) {
        this.recipe = recipe;
        class_1856 texture = recipe.getTexture();
        class_5455 access = Objects.requireNonNull(SafeClientAccess.getRegistryAccess());
        List<class_1799> displayOutputs = Arrays.stream(texture.method_8105()).map(stack -> recipe.method_8110(access)).toList();
        this.displayOutputs = displayOutputs.isEmpty() ? List.of(this.recipe.method_8110(access)) : displayOutputs;
        class_2371 inputs = recipe.method_8117();
        this.textureSlots = IntStream.range(0, inputs.size()).filter(arg_0 -> RetexturableRecipeExtension.lambda$new$1(texture, (List)inputs, arg_0)).toArray();
    }

    private static boolean ingredientsMatch(class_1856 left, class_1856 right) {
        class_1799[] rightStacks;
        class_1799[] leftStacks = left.method_8105();
        if (leftStacks.length != (rightStacks = right.method_8105()).length) {
            return false;
        }
        for (int i = 0; i < leftStacks.length; ++i) {
            if (class_1799.method_31577((class_1799)leftStacks[i], (class_1799)rightStacks[i])) continue;
            return false;
        }
        return true;
    }

    public class_2960 getRegistryName() {
        return this.recipe.method_8114();
    }

    public int getWidth() {
        return this.recipe.method_8150();
    }

    public int getHeight() {
        return this.recipe.method_8158();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ICraftingGridHelper craftingGridHelper, IFocusGroup focuses) {
        builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStack(this.recipe.method_8110(Objects.requireNonNull(SafeClientAccess.getRegistryAccess())));
        List<List> inputStacks = this.recipe.method_8117().stream().map(ingredient -> List.of(ingredient.method_8105())).toList();
        int width = this.recipe.method_8150();
        int height = this.recipe.method_8158();
        List inputs = craftingGridHelper.createAndSetInputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, inputStacks, this.recipe.method_8150(), this.recipe.method_8158());
        IRecipeSlotBuilder output = craftingGridHelper.createAndSetOutputs(builder, this.displayOutputs);
        if (inputs.size() != 9) {
            Mantle.logger.error("Failed to create focus link for {} as the layout {} is not 3x3", (Object)this.recipe.method_8114(), (Object)builder.getClass().getName());
        } else {
            builder.createFocusLink((IIngredientAcceptor[])Streams.concat((Stream[])new Stream[]{Stream.of(output), Arrays.stream(this.textureSlots).mapToObj(i -> (IRecipeSlotBuilder)inputs.get(RetexturableRecipeExtension.getCraftingIndex(i, width, height)))}).toArray(IRecipeSlotBuilder[]::new));
        }
    }

    private static int getCraftingIndex(int i, int width, int height) {
        int index;
        if (width == 1) {
            index = height == 3 ? i * 3 + 1 : (height == 2 ? i * 3 + 1 : 4);
        } else if (height == 1) {
            index = i + 3;
        } else if (width == 2) {
            index = i;
            if (i > 1) {
                ++index;
                if (i > 3) {
                    ++index;
                }
            }
        } else {
            index = height == 2 ? i + 3 : i;
        }
        return index;
    }

    private static /* synthetic */ boolean lambda$new$1(class_1856 texture, List inputs, int i) {
        return RetexturableRecipeExtension.ingredientsMatch(texture, (class_1856)inputs.get(i));
    }
}

